/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipEncap_Public.h 74978 2018-03-29 12:37:45Z kai $:

Description:
  Task EthernetIP Encapsulation
  Public declaration of task

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2010-11-01    created
**************************************************************************************/

#ifndef __EIPENCAP_PUBLIC_H
#define __EIPENCAP_PUBLIC_H

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EIPENCAP_PUBLIC)
#endif

#define EIP_ENCAP_DATA_PCKT_LEN 1520
#define EIP_ENCAP_MAX_PCKT_LEN  2048


/* some defines we have to move same later to an other header or subsystem */
#define CT_TCP           (TCP_PROTO_TCP)
#define CT_UDP           (TCP_PROTO_UDP)
#define CT_CL1           (TCP_PROTO_UDP+1)
#define CT_UDP_OUT       (TCP_PROTO_UDP+2)
#define CT_UDP_DHCPBOOTP (TCP_PROTO_UDP+3)

/***************************************************************************************
* Eip Encap constants */

/* Transport connection types */
#define ENCAP_CONN_TYPE_EXCL_OWNER     0x01   /* Exclusive owner */
#define ENCAP_CONN_TYPE_INPUT_ONLY     0x02   /* Input only      */
#define ENCAP_CONN_TYPE_LISTEN_ONLY    0x03   /* Listen only     */

/* Boot Server Enable Flags */
#define ENCAP_BOOTSERV_FLAG_BOOTP      0x01   /* Enable reception of BOOTP requests */


/* TCP connection management defines.
 * Encapsulation inactivity timeout: */
#define EIP_TI_INST_ATTR_ENCAPINACTIVITYTIMEOUT_DEFAULT  120           /* default value in seconds   */
#define EIP_TI_INST_ATTR_ENCAPINACTIVITYTIMEOUT_MAX     3600           /* maximum value in seconds   */

/***************************************************************************************
* Eip Encap commands */
#define  EIP_ENCAP_CREATE_TRANSP_REQ                 0x00001802
#define  EIP_ENCAP_CREATE_TRANSP_CNF                 0x00001803

#define  EIP_ENCAP_START_TRANSP_REQ                  0x00001804
#define  EIP_ENCAP_START_TRANSP_CNF                  0x00001805

#define  EIP_ENCAP_DELETE_TRANSP_REQ                 0x00001806
#define  EIP_ENCAP_DELETE_TRANSP_CNF                 0x00001807

#define  EIP_ENCAP_ABORT_TRANSP_IND                  0x00001808
#define  EIP_ENCAP_ABORT_TRANSP_RES                  0x00001809

#define  EIP_ENCAP_LISTIDENTITY_REQ                  0x00001810   /*!< Request a List Identity                */
#define  EIP_ENCAP_LISTIDENTITY_CNF                  0x00001811
#define  EIP_ENCAP_LISTIDENTITY_IND                  0x00001812   /*!< Indicate a List Identity Answer        */
#define  EIP_ENCAP_LISTIDENTITY_RES                  0x00001813

#define  EIP_ENCAP_LISTSERVICE_REQ                   0x00001814   /*!< Request a List Service                 */
#define  EIP_ENCAP_LISTSERVICE_CNF                   0x00001815
#define  EIP_ENCAP_LISTSERVICE_IND                   0x00001816   /*!< Indicate a List Service Answer         */
#define  EIP_ENCAP_LISTSERVICE_RES                   0x00001817

#define  EIP_ENCAP_LISTINTERFACE_REQ                 0x00001818   /*!< Request a List Interface               */
#define  EIP_ENCAP_LISTINTERFACE_CNF                 0x00001819
#define  EIP_ENCAP_LISTINTERFACE_IND                 0x0000181A   /*!< Indicate a List Interface Answer       */
#define  EIP_ENCAP_LISTINTERFACE_RES                 0x0000181B

#define  EIP_ENCAP_GET_RR_IND                        0x0000181C   /*!< Get an unconnected service             */
#define  EIP_ENCAP_GET_RR_RES                        0x0000181D
#define  EIP_ENCAP_RESP_RR_REQ                       0x0000181E   /*!< Send a response to an unconnected service */
#define  EIP_ENCAP_RESP_RR_CNF                       0x0000181F
#define	 EIP_ENCAP_SEND_RR_REQ                       0x00001820   /*!< Send an unconnected service request    */
#define  EIP_ENCAP_SEND_RR_CNF                       0x00001821

#define	 EIP_ENCAP_SEND_CL3_REQ                      0x00001822   /*!< Send a connected service request       */
#define  EIP_ENCAP_SEND_CL3_CNF                      0x00001823

#define  EIP_ENCAP_RESET_REQ                         0x00001824
#define  EIP_ENCAP_RESET_CNF                         0x00001825

#define  EIP_ENCAP_CHANGE_TCP_CONFIG_REQ             0x00001826
#define  EIP_ENCAP_CHANGE_TCP_CONFIG_CNF             0x00001827

#define  EIP_ENCAP_QOS_CFG_REQ                       0x00001828
#define  EIP_ENCAP_QOS_CFG_CNF                       0x00001829

#define  EIP_ENCAP_GET_RESOURCES_REQ                 0x00001880
#define  EIP_ENCAP_GET_RESOURCES_CNF                 0x00001881

#define  EIP_ENCAP_RECV_FRAME_IND                    0x00001882
#define  EIP_ENCAP_RECV_FRAME_RET                    0x00001883

#define  EIP_ENCAP_BOOT_REQEST_IND                   0x00001884
#define  EIP_ENCAP_BOOT_REQEST_RES                   0x00001885

#define  EIP_ENCAP_ENABLE_BOOT_SERVER_REQ            0x00001886
#define  EIP_ENCAP_ENABLE_BOOT_SERVER_CNF            0x00001887

#define  EIP_ENCAP_CLOSE_SESSION_REQ                 0x00001888
#define  EIP_ENCAP_CLOSE_SESSION_CNF                 0x00001889

#define  EIP_ENCAP_ABORT_SESSION_REQ                 0x0000188A
#define  EIP_ENCAP_ABORT_SESSION_CNF                 0x0000188B

  /* Indication that are used intern by timer */
#define  EIP_ENCAP_CL1_TIMER_IND                     0x000018E8
#define  EIP_ENCAP_SEND_CL1_IND                      0x000018EA
#define  EIP_ENCAP_TRANSP_TIMEOUT_IND                0x000018EC
#define  EIP_ENCAP_REQUEST_END_IND                   0x000018EE
#define  EIP_ENCAP_CYCLIC_EVENT_IND                  0x000018EF
#define  EIP_ENCAP_SEND_MSG_IND                      0x000018F0
#define  EIP_ENCAP_SET_INACTIVITY_TIMEOUT_IND        0x000018F2


/****************************************************************************************
* Eip Encap, packets */

typedef struct EIP_ENCAP_LISTIDENTITY_REQ_Ttag            EIP_ENCAP_LISTIDENTITY_REQ_T;
typedef struct EIP_ENCAP_PACKET_LISTIDENTITY_REQ_Ttag     EIP_ENCAP_PACKET_LISTIDENTITY_REQ_T;
typedef struct EIP_ENCAP_LISTIDENTITY_CNF_Ttag            EIP_ENCAP_LISTIDENTITY_CNF_T;
typedef struct EIP_ENCAP_PACKET_LISTIDENTITY_CNF_Ttag     EIP_ENCAP_PACKET_LISTIDENTITY_CNF_T;
typedef struct EIP_ENCAP_LISTIDENTITY_IND_Ttag            EIP_ENCAP_LISTIDENTITY_IND_T;
typedef struct EIP_ENCAP_PACKET_LISTIDENTITY_IND_Ttag     EIP_ENCAP_PACKET_LISTIDENTITY_IND_T;

typedef struct EIP_ENCAP_LISTSERVICE_REQ_Ttag             EIP_ENCAP_LISTSERVICE_REQ_T;
typedef struct EIP_ENCAP_PACKET_LISTSERVICE_REQ_Ttag      EIP_ENCAP_PACKET_LISTSERVICE_REQ_T;
typedef struct EIP_ENCAP_LISTSERVICE_CNF_Ttag             EIP_ENCAP_LISTSERVICE_CNF_T;
typedef struct EIP_ENCAP_PACKET_LISTSERVICE_CNF_Ttag      EIP_ENCAP_PACKET_LISTSERVICE_CNF_T;
typedef struct EIP_ENCAP_LISTSERVICE_IND_Ttag             EIP_ENCAP_LISTSERVICE_IND_T;
typedef struct EIP_ENCAP_PACKET_LISTSERVICE_IND_Ttag      EIP_ENCAP_PACKET_LISTSERVICE_IND_T;

typedef struct EIP_ENCAP_LISTINTERFACE_REQ_Ttag           EIP_ENCAP_LISTINTERFACE_REQ_T;
typedef struct EIP_ENCAP_PACKET_LISTINTERFACE_REQ_Ttag    EIP_ENCAP_PACKET_LISTINTERFACE_REQ_T;
typedef struct EIP_ENCAP_LISTINTERFACE_CNF_Ttag           EIP_ENCAP_LISTINTERFACE_CNF_T;
typedef struct EIP_ENCAP_PACKET_LISTINTERFACE_CNF_Ttag    EIP_ENCAP_PACKET_LISTINTERFACE_CNF_T;
typedef struct EIP_ENCAP_LISTINTERFACE_IND_Ttag           EIP_ENCAP_LISTINTERFACE_IND_T;
typedef struct EIP_ENCAP_PACKET_LISTINTERFACE_IND_Ttag    EIP_ENCAP_PACKET_LISTINTERFACE_IND_T;

typedef struct EIP_ENCAP_GET_RR_IND_Ttag                 EIP_ENCAP_GET_RR_IND_T;
typedef struct EIP_ENCAP_PACKET_GET_RR_IND_Ttag          EIP_ENCAP_PACKET_GET_RR_IND_T;
typedef struct EIP_ENCAP_GET_RR_RES_Ttag                 EIP_ENCAP_GET_RR_RES_T;
typedef struct EIP_ENCAP_PACKET_GET_RR_RES_Ttag          EIP_ENCAP_PACKET_GET_RR_RES_T;
typedef struct EIP_ENCAP_RESP_RR_REQ_Ttag                EIP_ENCAP_RESP_RR_REQ_T;
typedef struct EIP_ENCAP_PACKET_RESP_RR_REQ_Ttag         EIP_ENCAP_PACKET_RESP_RR_REQ_T;
typedef struct EIP_ENCAP_RESP_RR_CNF_Ttag                EIP_ENCAP_RESP_RR_CNF_T;
typedef struct EIP_ENCAP_PACKET_RESP_RR_CNF_Ttag         EIP_ENCAP_PACKET_RESP_RR_CNF_T;

typedef struct EIP_ENCAP_SEND_RR_REQ_Ttag                EIP_ENCAP_SEND_RR_REQ_T;
typedef struct EIP_ENCAP_PACKET_SEND_RR_REQ_Ttag         EIP_ENCAP_PACKET_SEND_RR_REQ_T;
typedef struct EIP_ENCAP_SEND_RR_CNF_Ttag                EIP_ENCAP_SEND_RR_CNF_T;
typedef struct EIP_ENCAP_PACKET_SEND_RR_CNF_Ttag         EIP_ENCAP_PACKET_SEND_RR_CNF_T;

typedef struct EIP_ENCAP_SEND_CL3_REQ_Ttag               EIP_ENCAP_SEND_CL3_REQ_T;
typedef struct EIP_ENCAP_PACKET_SEND_CL3_REQ_Ttag        EIP_ENCAP_PACKET_SEND_CL3_REQ_T;
typedef struct EIP_ENCAP_SEND_CL3_CNF_Ttag               EIP_ENCAP_SEND_CL3_CNF_T;
typedef struct EIP_ENCAP_PACKET_SEND_CL3_CNF_Ttag        EIP_ENCAP_PACKET_SEND_CL3_CNF_T;

typedef struct EIP_ENCAP_SET_INACTIVITY_TIMEOUT_IND_Ttag         EIP_ENCAP_SET_INACTIVITY_TIMEOUT_IND_T;
typedef struct EIP_ENCAP_PACKET_SET_INACTIVITY_TIMEOUT_IND_Ttag  EIP_ENCAP_PACKET_SET_INACTIVITY_TIMEOUT_IND_T;

/* packets for handle Transports */
typedef struct EIP_ENCAP_PACKET_ABORT_TRANSP_RES_Ttag     EIP_ENCAP_PACKET_ABORT_TRANSP_RES_T;
typedef struct EIP_ENCAP_ABORT_TRANSP_RES_Ttag            EIP_ENCAP_ABORT_TRANSP_RES_T;
typedef struct EIP_ENCAP_PACKET_ABORT_TRANSP_IND_Ttag     EIP_ENCAP_PACKET_ABORT_TRANSP_IND_T;
typedef struct EIP_ENCAP_ABORT_TRANSP_IND_Ttag            EIP_ENCAP_ABORT_TRANSP_IND_T;
typedef struct EIP_ENCAP_PACKET_CREATE_TRANSP_REQ_Ttag    EIP_ENCAP_PACKET_CREATE_TRANSP_REQ_T;
typedef struct EIP_ENCAP_CREATE_TRANSP_REQ_Ttag           EIP_ENCAP_CREATE_TRANSP_REQ_T;
typedef struct EIP_ENCAP_PACKET_CREATE_TRANSP_CNF_Ttag    EIP_ENCAP_PACKET_CREATE_TRANSP_CNF_T;
typedef struct EIP_ENCAP_CREATE_TRANSP_CNF_Ttag           EIP_ENCAP_CREATE_TRANSP_CNF_T;
typedef struct EIP_ENCAP_PACKET_START_TRANSP_REQ_Ttag     EIP_ENCAP_PACKET_START_TRANSP_REQ_T;
typedef struct EIP_ENCAP_START_TRANSP_REQ_Ttag            EIP_ENCAP_START_TRANSP_REQ_T;
typedef struct EIP_ENCAP_PACKET_START_TRANSP_CNF_Ttag     EIP_ENCAP_PACKET_START_TRANSP_CNF_T;
typedef struct EIP_ENCAP_START_TRANSP_CNF_Ttag            EIP_ENCAP_START_TRANSP_CNF_T;
typedef struct EIP_ENCAP_PACKET_DELETE_TRANSP_CNF_Ttag    EIP_ENCAP_PACKET_DELETE_TRANSP_CNF_T;
typedef struct EIP_ENCAP_DELETE_TRANSP_CNF_Ttag           EIP_ENCAP_DELETE_TRANSP_CNF_T;
typedef struct EIP_ENCAP_PACKET_DELETE_TRANSP_REQ_Ttag    EIP_ENCAP_PACKET_DELETE_TRANSP_REQ_T;
typedef struct EIP_ENCAP_DELETE_TRANSP_REQ_Ttag           EIP_ENCAP_DELETE_TRANSP_REQ_T;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_GET_RR_IND_Ttag
{
  TLR_UINT32      ulDataIdx;          /* Index of the service         */
  TLR_UINT32      ulLenData;          /* Length of the valid data     */
  TLR_UINT32      ulOffset;           /* Offset were the data start   */
  TLR_UINT8       abData[EIP_ENCAP_DATA_PCKT_LEN];       /* Buffer for the Data packet   */
}__PACKED_POST ;

#define EIP_ENCAP_GET_RR_IND_SIZE (sizeof(EIP_ENCAP_GET_RR_IND_T) - EIP_ENCAP_DATA_PCKT_LEN)

__PACKED_PRE struct EIP_ENCAP_PACKET_GET_RR_IND_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_GET_RR_IND_T          tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_GET_RR_RES_Ttag
{
  TLR_UINT32      ulDataIdx;          /* Index of the service         */
} __PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_GET_RR_RES_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_GET_RR_RES_T          tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_RESP_RR_REQ_Ttag
{
  TLR_UINT32      ulDataIdx;          /* Index of the service         */
  TLR_UINT32      ulLenData;          /* Length of the valid data     */
  TLR_UINT32      ulOffset;           /* Offset were the data start   */
  TLR_UINT8       abData[EIP_ENCAP_DATA_PCKT_LEN];       /* Buffer for the Data packet   */
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_RESP_RR_REQ_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_RESP_RR_REQ_T         tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_RESP_RR_CNF_Ttag
{
  TLR_UINT32      ulDataIdx;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_RESP_RR_CNF_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_RESP_RR_CNF_T         tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_SEND_RR_REQ_Ttag
{
  TLR_UINT32 ulPort;                            /* Port to send                 */
  TLR_UINT32 ulIpAddr;                          /* IP Address to send           */
  TLR_UINT32 ulTimeout;                         /* Timeout for sending          */
  TLR_UINT32 ulLenData;                         /* Length of the valid data     */
  TLR_UINT32 ulOffset;                          /* Offset were the data start   */
  TLR_UINT32 ulFlag;
  TLR_UINT8  abData[EIP_ENCAP_DATA_PCKT_LEN];   /* Buffer for the Data packet   */
}__PACKED_POST ;

#define EIP_ENCAP_FLAG_ADD_TO_SOCKET_ITEM   0x0000001

__PACKED_PRE struct EIP_ENCAP_PACKET_SEND_RR_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_ENCAP_SEND_RR_REQ_T         tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_SEND_RR_CNF_Ttag
{
  TLR_UINT32      ulLenData;                        /* Length of the valid data     */
  TLR_UINT32      ulOffset;                         /* Offset were the data start   */
  TLR_UINT8       abData[EIP_ENCAP_DATA_PCKT_LEN];  /* Buffer for the Data packet   */
}__PACKED_POST ;

#define EIP_ENCAP_SEND_RR_CNF_SIZE 8

__PACKED_PRE struct EIP_ENCAP_PACKET_SEND_RR_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_ENCAP_SEND_RR_CNF_T         tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_SEND_CL3_REQ_Ttag
{
  TLR_UINT32 ulTransportID;                   /* ID of the Transport that should send the data */
  TLR_UINT32 ulLenData;                       /* Length of the valid data                      */
  TLR_UINT32 ulOffset;                        /* Offset were the data start                    */
  TLR_UINT8  abData[EIP_ENCAP_DATA_PCKT_LEN]; /* Buffer for the Data packet                    */
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_SEND_CL3_REQ_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_SEND_CL3_REQ_T         tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_SEND_CL3_CNF_Ttag
{
  TLR_UINT32      ulLenData;                           /* Length of the valid data     */
  TLR_UINT32      ulOffset;                            /* Offset were the data start   */
  TLR_UINT8       abData[EIP_ENCAP_DATA_PCKT_LEN];     /* Buffer for the Data packet   */
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_SEND_CL3_CNF_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_SEND_CL3_CNF_T         tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_SET_INACTIVITY_TIMEOUT_IND_Ttag
{
  TLR_UINT16      usInactivityTimeoutValue; /* in seconds */
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_SET_INACTIVITY_TIMEOUT_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EIP_ENCAP_SET_INACTIVITY_TIMEOUT_IND_T  tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct  EIP_ENCAP_CREATE_TRANSP_REQ_Ttag
{
  TLR_UINT32  ulOrginator;          /* do not change need it at the same position for the response */
  TLR_UINT32  ulMultiplier;
  TLR_UINT32  ulTimeout;
  TLR_UINT32  ulProRPI;             /* Producing RPI in microseconds */
  TLR_UINT32  ulProParam;
  TLR_UINT8  *pbProData;
  TLR_UINT32  ulConRPI;             /* Consuming RPI in microseconds */
  TLR_UINT32  ulConParam;
  TLR_UINT8  *pbConData;
  TLR_UINT32  ulProConnID;
  TLR_UINT32  ulConConnID;
  TLR_UINT32  ulClass;
  TLR_VOID  *pProFunc;
  TLR_VOID  *pProParam;
  TLR_VOID  *pConFunc;
  TLR_VOID  *pConParam;
  TLR_VOID  *ptPkt;
  TLR_VOID  *hRefTransport;             /* Transport Reference if already a connection is opened. */
  TLR_UINT8  bConnectionType;           /* Exclusive owner/ listen only/ input only               */
  TLR_VOID  *pFirstRcvFunc;
  TLR_VOID  *pFirstRcvFuncParam;
  TLR_UINT8  bTTLValue;                 /* Time to live that shall be used for this transport                 */
  TLR_UINT32 ulMulticastStartAddr;      /* If != 0, this address shall be used as multicast start offset      */
  TLR_UINT32 ulNumberOfAddresses;       /* Number of multicast addresses to use                               */
  TLR_UINT32 ulProductionInhibitTimeUs; /* Production Inhibit Time in microseconds as defined in CIP Volume 1 */
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_CREATE_TRANSP_REQ_Ttag
{
  TLR_PACKET_HEADER_T              tHead;
  EIP_ENCAP_CREATE_TRANSP_REQ_T    tData;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_CREATE_TRANSP_CNF_Ttag
{
  TLR_UINT32 ulOrginator;               /* do not change need it at the same position for the response */
  TLR_UINT32 ulTransportID;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_CREATE_TRANSP_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_CREATE_TRANSP_CNF_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct  EIP_ENCAP_START_TRANSP_REQ_Ttag
{
  TLR_UINT32 ulTransportID;
  TLR_UINT32 ulProConnID;
  TLR_UINT32 ulConConnID;
  TLR_UINT32 ulProApi;
  TLR_UINT32 ulConApi;
  TLR_UINT32 ulMultiplier;
  TLR_UINT32 ulMCIpAddr;
  TLR_UINT32 ulMCPort;
  TLR_UINT32 ulOTPort;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_START_TRANSP_REQ_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  EIP_ENCAP_START_TRANSP_REQ_T tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_START_TRANSP_CNF_Ttag
{
  TLR_UINT32 ulTransportID;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_START_TRANSP_CNF_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  EIP_ENCAP_START_TRANSP_CNF_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct  EIP_ENCAP_DELETE_TRANSP_CNF_Ttag
{
  TLR_UINT32 ulTransportID;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_DELETE_TRANSP_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_DELETE_TRANSP_CNF_T tData;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_DELETE_TRANSP_REQ_Ttag
{
  TLR_UINT32 ulTransportID;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_DELETE_TRANSP_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_DELETE_TRANSP_REQ_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_ABORT_TRANSP_IND_Ttag
{
    TLR_UINT32 ulTransportID;
    TLR_UINT32 ulTimeout;     /* Reason for abortion; ulTimeout == 1 if timeout occured */
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_ABORT_TRANSP_IND_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  EIP_ENCAP_ABORT_TRANSP_IND_T tData;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_ABORT_TRANSP_RES_Ttag
{
  TLR_UINT32 ulTransportID;
}__PACKED_POST ;

__PACKED_PRE struct  EIP_ENCAP_PACKET_ABORT_TRANSP_RES_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  EIP_ENCAP_ABORT_TRANSP_RES_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_LISTIDENTITY_REQ_Ttag
{
  TLR_UINT32  ulIPAddr;
  TLR_UINT32  ulTimeout;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTIDENTITY_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTIDENTITY_REQ_T tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTIDENTITY_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_LISTIDENTITY_IND_Ttag
{
  TLR_UINT8 abData[EIP_ENCAP_MAX_PCKT_LEN];
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTIDENTITY_IND_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTIDENTITY_IND_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_LISTSERVICE_REQ_Ttag
{
  TLR_UINT32  ulIPAddr;
  TLR_UINT32  ulTimeout;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTSERVICE_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTSERVICE_REQ_T tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTSERVICE_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_LISTSERVICE_IND_Ttag
{
  TLR_UINT8 abData[EIP_ENCAP_MAX_PCKT_LEN];
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTSERVICE_IND_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTSERVICE_IND_T tData;
}__PACKED_POST ;

/* ####################################################### */
__PACKED_PRE struct EIP_ENCAP_LISTINTERFACE_REQ_Ttag
{
  TLR_UINT32  ulIPAddr;
  TLR_UINT32  ulTimeout;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTINTERFACE_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTINTERFACE_REQ_T tData;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTINTERFACE_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_LISTINTERFACE_IND_Ttag
{
  TLR_UINT8 abData[EIP_ENCAP_MAX_PCKT_LEN];
}__PACKED_POST ;

__PACKED_PRE struct EIP_ENCAP_PACKET_LISTINTERFACE_IND_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_LISTINTERFACE_IND_T tData;
}__PACKED_POST ;

/* ####################################################### */
typedef __PACKED_PRE struct EIP_ENCAP_CHANGE_TCP_CONFIG_REQ_Ttag
{
  TLR_UINT32 ulFlags;
  TLR_UINT32 ulIpAddr;
  TLR_UINT32 ulNetMask;
  TLR_UINT32 ulGateway;
  TLR_UINT8  abEthernetAddr[6];
}__PACKED_POST EIP_ENCAP_CHANGE_TCP_CONFIG_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_CHANGE_TCP_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_CHANGE_TCP_CONFIG_REQ_T tData;
}__PACKED_POST  EIP_ENCAP_PACKET_CHANGE_TCP_CONFIG_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_CHANGE_TCP_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST  EIP_ENCAP_PACKET_CHANGE_TCP_CONFIG_CNF_T;

#define EIP_ENCAP_CHANGE_TCP_CONFIG_REQ_SIZE (sizeof(EIP_ENCAP_CHANGE_TCP_CONFIG_REQ_T))
#define EIP_ENCAP_CHANGE_TCP_CONFIG_CNF_SIZE (0)

/* ####################################################### */
typedef __PACKED_PRE struct EIP_ENCAP_QOS_CFG_REQ_Ttag
{
  TLR_UINT8     bTag802Enable;
  TLR_UINT8     bDSCP_PTP_Event;
  TLR_UINT8     bDSCP_PTP_General;
  TLR_UINT8     bDSCP_Urgent;
  TLR_UINT8     bDSCP_Scheduled;
  TLR_UINT8     bDSCP_High;
  TLR_UINT8     bDSCP_Low;
  TLR_UINT8     bDSCP_Explicit;

}__PACKED_POST EIP_ENCAP_QOS_CFG_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_QOS_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_QOS_CFG_REQ_T tData;
}__PACKED_POST  EIP_ENCAP_PACKET_QOS_CFG_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_QOS_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST  EIP_ENCAP_PACKET_QOS_CFG_CNF_T;

#define EIP_ENCAP_QOS_CFG_REQ_SIZE (sizeof(EIP_ENCAP_QOS_CFG_REQ_T))
#define EIP_ENCAP_QOS_CFG_CNF_SIZE (0)

/* ####################################################### */
 typedef __PACKED_PRE struct EIP_ENCAP_GET_RESOURCES_REQ_Ttag
{
   TLR_VOID *ptRsc;
}__PACKED_POST  EIP_ENCAP_GET_RESOURCES_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_GET_RESOURCES_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_GET_RESOURCES_REQ_T tData;
}__PACKED_POST  EIP_ENCAP_PACKET_GET_RESOURCES_REQ_T;

typedef __PACKED_PRE struct EIP_ENCAP_GET_RESOURCES_CNF_Ttag
{
  TLR_VOID *ptRsc;
  TLR_HANDLE hTimer;
}__PACKED_POST  EIP_ENCAP_GET_RESOURCES_CNF_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_GET_RESOURCES_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_GET_RESOURCES_CNF_T tData;
}__PACKED_POST  EIP_ENCAP_PACKET_GET_RESOURCES_CNF_T;

#define EIP_ENCAP_GET_RESOURCES_REQ_SIZE (sizeof(EIP_ENCAP_GET_RESOURCES_REQ_T))
#define EIP_ENCAP_GET_RESOURCES_CNF_SIZE (sizeof(EIP_ENCAP_GET_RESOURCES_CNF_T))

/* ####################################################### */
typedef __PACKED_PRE struct EIP_ENCAP_RECV_FRAME_IND_Ttag
{
  TLR_UINT8 * ptBuf;
  TLR_UINT32 uiLength;

}__PACKED_POST  EIP_ENCAP_RECV_FRAME_IND_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_RECV_FRAME_IND_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
  EIP_ENCAP_RECV_FRAME_IND_T tData;
}__PACKED_POST  EIP_ENCAP_PACKET_RECV_FRAME_IND_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_RECV_FRAME_RET_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
}__PACKED_POST  EIP_ENCAP_PACKET_RECV_FRAME_RET_T;

#define EIP_ENCAP_RECV_FRAME_IND_SIZE (sizeof(EIP_ENCAP_RECV_FRAME_IND_T))
#define EIP_ENCAP_RECV_FRAME_RET_SIZE 0


/* ####################################################### */
typedef __PACKED_PRE struct BOOT_PACKET_Ttag
{
  TLR_UINT8   bOp;                   /* Op code */
  TLR_UINT8   bHType;                /* Hardware address type */
  TLR_UINT8   bHLen;                 /* Hardware address length */
  TLR_UINT8   bHops;                 /* Hops (optionally used by relay agents) */
  TLR_UINT32  ulXid;                 /* Transaction id */
  TLR_UINT16  usSecs;                /* Seconds since start of address acquisition or renewal */
  TLR_UINT16  usFlags;               /* Flags */
  TLR_UINT32  ulCIAddr;              /* Client IP address */
  TLR_UINT32  ulYIAddr;              /* 'your' (client) IP address */
  TLR_UINT32  ulSIAddr;              /* IP address of next server to use in bootstrap */
  TLR_UINT32  ulGIAddr;              /* Relay agent IP address */
  TLR_UINT8   abCHAddr[16];          /* Client hardware address */
  TLR_UINT8   szSName[64];           /* Server host name (optional) */
  TLR_UINT8   szFile[128];           /* Boot file name */
  TLR_UINT32  ulMagicCookie;         /* Magic cookie */
  TLR_UINT8   abOptions[312];        /* Optional parameter field */

} __PACKED_POST BOOT_PACKET_T;

typedef __PACKED_PRE struct EIP_ENCAP_BOOT_IND_Ttag
{
  BOOT_PACKET_T tBootData;

} __PACKED_POST EIP_ENCAP_BOOT_IND_T;

#define EIP_ENCAP_BOOT_REQEST_IND_SIZE sizeof(EIP_ENCAP_BOOT_IND_T)

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_BOOT_IND_Ttag
{
  TLR_PACKET_HEADER_T   tHead;
  EIP_ENCAP_BOOT_IND_T  tData;
} __PACKED_POST EIP_ENCAP_PACKET_BOOT_IND_T;

#define EIP_ENCAP_BOOT_REQEST_IND_SIZE sizeof(EIP_ENCAP_BOOT_IND_T)

typedef __PACKED_PRE struct EIP_ENCAP_BOOT_RES_Ttag
{
  BOOT_PACKET_T tBootData;

} __PACKED_POST EIP_ENCAP_BOOT_RES_T;

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_BOOT_RES_Ttag
{
  TLR_PACKET_HEADER_T   tHead;
  EIP_ENCAP_BOOT_RES_T  tData;
} __PACKED_POST EIP_ENCAP_PACKET_BOOT_RES_T;

/* ####################################################### */

typedef __PACKED_PRE struct EIP_ENCAP_ENABLE_BOOT_SERVER_REQ_Ttag
{
  TLR_UINT32  ulEnable;

} __PACKED_POST EIP_ENCAP_ENABLE_BOOT_SERVER_REQ_T;


typedef __PACKED_PRE struct EIP_ENCAP_PACKET_ENABLE_BOOT_SERVER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  EIP_ENCAP_ENABLE_BOOT_SERVER_REQ_T tData;

} __PACKED_POST EIP_ENCAP_PACKET_ENABLE_BOOT_SERVER_REQ_T;

#define EIP_ENCAP_ENABLE_BOOT_SERVER_REQ_SIZE  sizeof(EIP_ENCAP_ENABLE_BOOT_SERVER_REQ_T)

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_ENABLE_BOOT_SERVER_CNF_Ttag
{
  TLR_PACKET_HEADER_T   tHead;

} __PACKED_POST EIP_ENCAP_PACKET_ENABLE_BOOT_SERVER_CNF_T;

#define EIP_ENCAP_ENABLE_BOOT_SERVER_CNF_SIZE  0

/* ####################################################### */

typedef __PACKED_PRE struct EIP_ENCAP_CLOSE_SESSION_REQ_Ttag
{
  TLR_UINT32  ulSessionID;

} __PACKED_POST EIP_ENCAP_CLOSE_SESSION_REQ_T;


typedef __PACKED_PRE struct EIP_ENCAP_PACKET_CLOSE_SESSION_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_CLOSE_SESSION_REQ_T tData;

} __PACKED_POST EIP_ENCAP_PACKET_CLOSE_SESSION_REQ_T;

#define EIP_ENCAP_CLOSE_SESSION_REQ_SIZE  sizeof(EIP_ENCAP_CLOSE_SESSION_REQ_T)

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_CLOSE_SESSION_CNF_Ttag
{
  TLR_PACKET_HEADER_T   tHead;

} __PACKED_POST EIP_ENCAP_PACKET_CLOSE_SESSION_CNF_T;

#define EIP_ENCAP_CLOSE_SESSION_CNF_SIZE  0

/* ####################################################### */

typedef __PACKED_PRE struct EIP_ENCAP_ABORT_SESSION_REQ_Ttag
{
  TLR_UINT32  ulIPAddr;

} __PACKED_POST EIP_ENCAP_ABORT_SESSION_REQ_T;


typedef __PACKED_PRE struct EIP_ENCAP_PACKET_ABORT_SESSION_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
  EIP_ENCAP_ABORT_SESSION_REQ_T tData;

} __PACKED_POST EIP_ENCAP_PACKET_ABORT_SESSION_REQ_T;

#define EIP_ENCAP_ABORT_SESSION_REQ_SIZE  sizeof(EIP_ENCAP_ABORT_SESSION_REQ_T)

typedef __PACKED_PRE struct EIP_ENCAP_PACKET_ABORT_SESSION_CNF_Ttag
{
  TLR_PACKET_HEADER_T   tHead;

} __PACKED_POST EIP_ENCAP_PACKET_ABORT_SESSION_CNF_T;

#define EIP_ENCAP_ABORT_SESSION_CNF_SIZE  0

/***************************************************************************************/
/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EIPENCAP_PUBLIC)
#endif

/***************************************************************************************/
/* Function API */

TLR_RESULT
EipEncap_Get_Handle( TLR_HANDLE* hHandle );

TLR_RESULT
EipEncap_Set_InactivityTimeout( TLR_HANDLE* hHandle,
                                TLR_UINT16  usInactivityTime );

#endif /* #ifndef __EIPENCAP_PUBLIC_H */
